/// EnemyStateIdle()

// If player detected then follow
if (instance_exists(target) && 
	point_distance(x, y, target.x, target.y) < 6 * GRID_SIZE &&
	y < target.y + GRID_SIZE*2-1 &&
	y > target.y - GRID_SIZE-1 &&
	image_xscale == sign(target.x - x)
){
		state = enemyState.follow;
} else {
	// do idle stuff
	if (--changeDirectionTimer <= 0) {
		EnemyChangeDirection();
	}
	if (--stopMovingTimer <= 0) {
		  stopMovingTimer  = Seconds(2);
		if (choose(true, false, false, false)) {
			xSpeed = 0;
			dontMove = true;
		} else {
			dontMove = false;
		}
	}
	
	if !dontMove {
		if (vertState == verticalState.onGround && !place_meeting(x + 64 * sign(xSpeed), y + 4, oCollision) && !NearZero(xSpeed)) {
			// Slow down
			xSpeed = lerp(xSpeed, 0, frict);
			
			if NearZero(xSpeed)
				EnemyChangeDirection();
		} else {
			if (image_xscale > 0 && xSpeed < maxMoveSpeed)
				xSpeed += accel;
			else if (image_xscale < 0 && xSpeed > -maxMoveSpeed)
				xSpeed -= accel;
		}
		
		if (abs(xSpeed) > maxMoveSpeed) {
			xSpeed -= sign(xSpeed) * (vertState == verticalState.onGround ? 2*frict : frict);
		}
	}
}